% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svgtools.R
\name{write_svg}
\alias{write_svg}
\title{Writes SVG to file}
\usage{
write_svg(svg, file, remove_hidden = TRUE, flatten = FALSE)
}
\arguments{
\item{svg}{XML document with SVG content.}

\item{file}{Path to file or connection to write to (see \code{\link[xml2]{write_xml}}).}

\item{remove_hidden}{Should hidden elements (with XML attribute display="none") be removed? (default TRUE)}

\item{flatten}{Should grouping of SVG elements be removed? (default FALSE)}
}
\description{
Writes SVG to file
}
\details{
Both \code{remove_hidden=TRUE} and \code{flatten=TRUE} do not alter the XML document object itself. Therefore, subsequent calls to \code{\link{stackedBar}} and other functions remain possible.
}
\examples{
#read SVG file
fpath <- system.file("extdata", "fig3.svg", package="svgtools")
svg <- read_svg(file = fpath)

#adjust some elements of SVG
svg <- stackedBar(svg = svg, frame_name = "frame", group_name = "overall", 
                  scale_real = c(0,160), values = c(10,42,106), 
                  alignment = "vertical")

\dontrun{
#write SVG file to disk and remove all groupings
write_svg(svg = svg, file = "myChart.svg", flatten = TRUE)
}
}
