% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_survival}
\alias{plot_survival}
\title{Plot survival curves from a survextrap model}
\usage{
plot_survival(
  x,
  newdata = NULL,
  t = NULL,
  tmax = NULL,
  km = NULL,
  niter = NULL,
  newdata0 = NULL,
  wane_period = NULL,
  wane_nt = 10,
  ci = NULL,
  xlab = "Time",
  ylab = "Survival",
  line_size = 1.5,
  ci_alpha = 0.2,
  show_knots = FALSE
)
}
\arguments{
\item{x}{A fitted model object as returned by \code{\link{survextrap}}}

\item{newdata}{Data frame of covariate values to compute the output for.
If there are covariates in the model and this is not supplied,
the following default is used:

(a) if the only covariate is one factor variable, then the output is computed
for each level of this factor.

(b) if there are multiple covariates, or any numeric covariates, then the output
is computed at the mean of each numeric covariate in the original data, and at the
baseline level of each factor covariate.

Note: caution is required about how treatment groups (for example)
are stored in your data.  If these are coded as numeric (0/1),
then if \code{newdata} is not specified, only one output will be shown.
This relates to the average value of this numeric variable over
the data, which doesn't correspond to either of the treatment
groups.  To avoid this, a treatment group should be stored as a
factor.}

\item{t}{Vector of times at which to compute the estimates.}

\item{tmax}{Maximum time at which to compute the estimates.  If
\code{t} is supplied, then this is ignored.  If \code{t} is not
supplied, then \code{t} is set to a set of 100 equally spaced
time points from 0 to \code{tmax}.  If both \code{tmax} and \code{t}
are not supplied, then \code{tmax} is set to the maximum follow up time
in the data.}

\item{km}{If \code{TRUE} then a Kaplan-Meier curve of the observed
data is plotted, using the results of
\code{\link[survival:survfit]{survival::survfit()}} on the
formula originally used for the \code{survextrap} fit.  By
default, this is only done when there are no covariates or one
factor covariate.

The Kaplan-Meier estimates are returned in the \code{km} component
of the fitted model object returned by \code{\link{survextrap}},
for use in hand-crafted plots like these.}

\item{niter}{Number of MCMC iterations to use to compute credible
intervals.  Set to a low value to make this function quicker, at the cost of
some approximation error (which may not be important for plotting or model
development).}

\item{newdata0}{Data frame of covariate values defining the "untreated" group
for use in treatment waning models. See \code{\link{Survmspline_wane}}.}

\item{wane_period}{Vector of two numbers, defining the time period over which
the hazard is interpolated between the hazard of the "treated" group (taken from \code{newdata})
and the hazard of the "untreated" group (taken from \code{newdata0}).  Optional - if
this is not supplied, then no waning is assumed.}

\item{wane_nt}{Number of intervals defining the piecewise constant approximation
to the hazard during the waning period.}

\item{ci}{If \code{TRUE} then credible intervals are drawn.  Defaults to
drawing the intervals if the plot shows the curve for only one covariate value.}

\item{xlab}{X-axis label}

\item{ylab}{Y-axis label}

\item{line_size}{Passed to \code{\link[ggplot2]{geom_line}}}

\item{ci_alpha}{Transparency for the credible interval ribbons}

\item{show_knots}{Show the locations of the spline knots as vertical lines}
}
\value{
A \code{ggplot2} plot object.
}
\description{
Plot survival curves from a \code{\link{survextrap}} model.  This
function is intended as a quick check of a fitted model, so it
deliberately has limited options for customisation.  The data
behind these plots can be extracted with \code{\link{survival}}
into a tidy data frame to enable custom plots to be constructed
with \pkg{ggplot2}.  See the \href{https://chjackson.github.io/survextrap/articles/cetuximab.html}{case study} vignette for some examples.
}
\details{
If the model has a single factor covariate (excluding background
hazard strata), then curves are produced for each level of this
factor if \code{newdata} requests this (or is left to its default).
Otherwise, only a single curve is produced, illustrating the
corresponding output from \code{\link{hazard}}.
}
