% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mspline_basis.R
\name{mspline_basis}
\alias{mspline_basis}
\title{Evaluate an M-spline basis matrix at the specified times.}
\usage{
mspline_basis(times, knots, degree = 3, integrate = FALSE, bsmooth = TRUE)
}
\arguments{
\item{times}{A numeric vector of times at which to evaluate the basis.}

\item{knots}{Spline knots}

\item{degree}{Spline degree}

\item{integrate}{If \code{TRUE}, then the integrated M-spline (I-spline) basis is returned.}

\item{bsmooth}{If \code{TRUE} then the function is constrained to
also have zero derivative and second derivative at the boundary,
which improves smoothness at the boundary.}
}
\value{
A two-dimensional array.  Rows are the times, and columns are the basis terms.
}
\description{
Evaluate an M-spline basis matrix at the specified times.
Extrapolation beyond the boundary knots is done by assuming that
each basis term is constant beyond the boundary.
}
\details{
The lower boundary is fixed to zero, and each basis term is
assumed to be zero at times less than zero, since these models are
used for hazard functions in survival data.
}
\references{
The \href{https://CRAN.R-project.org/package=splines2}{splines2} package is used.
}
