% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotVector.R
\name{plotVector}
\alias{plotVector}
\title{Plots a set of rectangles that represent a numeric vector.}
\usage{
plotVector(vectValues, width, coordX, coordY, rotationRadians, vectColor, bordColor)
}
\arguments{
\item{vectValues}{The heights of the rectangles. If \code{vectValues[i]}>=0 then the base of rectangle \code{i} is plotted at \code{coordY} and the top is plotted at \code{coordY} + (\code{abs(vectValues[i])}).  If the \code{vectValues[i]}<0 then the base of rectangle \code{i} is plotted at \code{coordY} and the bottom is plotted at \code{coordY} - \code{abs(vectValues[i])}.}

\item{width}{The width (positive number) of the rectangles. It can be either one number or a vector of numbers with the same length as \code{vectValues}.}

\item{coordX}{X coordinate of the left base corner of the first rectangle, \code{vectValues[1]}.}

\item{coordY}{Y coordinate of the left base corner of the first rectangle, \code{vectValues[1]}.}

\item{rotationRadians}{By how much (in radians) to rotate the aligned rectangles around \code{(coordX, coordY)}. The rotation is performed counter clock-wise.}

\item{vectColor}{The colors of the rectangles in \code{R} color format. It can be either one value or a vector of values with the same length as \code{vectValues}.}

\item{bordColor}{The color of the border of the rectangles. It can be either one value or a vector of values with the same length as \code{vectValues}.}
}
\value{
None
}
\description{
Plots a vector of numeric values as a set of rectangles with user specified height, width, color, and border color. The bases of the rectangles are aligned like in a histogram.
}
\details{
\code{R}-function \code{plot} has to be called first. The rectangles are aligned in the following manner. If \code{rotationRadians} is zero, then the base of all rectangles is at \code{coordY}. If \code{vectValues[i]>=0} then the top of the rectangle is plotted at \code{coordY} + \code{abs(vectValues[i])}. If the \code{vectValues[i]}<0 then the bottom of the rectangle is plotted at \code{coordY} - \code{abs(vectValues[i])}. If \code{rotationRadians} is not zero, then the aligned rectangles are rotated counter clock-wise around point (\code{coordX},\code{coordY}).
}
\examples{
### Histogram-like plot
plot(c(-1, 2), c(-1, 1), type = "n")
vectValues = c(0.057, 0.336, 0.260, 0.362, 0.209)
plotVector(vectValues, width = 0.2, coordX = 0, coordY = 0, rotationRadians = 0,
   vectColor = "gray", bordColor = "white")
   
### Rotated and flipped sequence of rectangles.
width = c(0.10, 0.20, 0.10, 0.80, 0.12)
vectColor = c("orange", "green", "orchid", "blue", "goldenrod1")
plot(c(-1, 2), c(-1, 2), type = "n")
plotVector(vectValues = vectValues, width, coordX = 0, coordY = 0,
   rotationRadians = pi/2, vectColor, bordColor = "white")
plotVector(vectValues = -vectValues, width, coordX = 0, coordY = 0,
   rotationRadians = 0, vectColor, bordColor = "white")
   
### Histogram-like plot with positive and negative values.
vectValues = c(0.057, -0.336, 0.260, -0.222, 0.209)
plot(c(-1, 1), c(-1, 1), type = "n")
vectColor = rep("goldenrod1", length(vectValues))
vectColor[vectValues<0] = "royalblue1"
bordColor = rep("red", length(vectValues))
bordColor[vectValues<0] = "darkblue"
plotVector(vectValues, width = 0.4, coordX = -1, coordY = 0, rotationRadians = 0,
    vectColor, bordColor = bordColor)

}
\author{
Svetlana K Eden, \email{svetlanaeden@gmail.com}
}
\keyword{color}
\keyword{histogram}
\keyword{rotated}
