# Tests for use_jama_theme() function

test_that("use_jama_theme() runs without error", {
  skip_if_not_installed("gtsummary")
  on.exit(gtsummary::reset_gtsummary_theme(), add = TRUE)

  expect_no_message(use_jama_theme())
})

test_that("use_jama_theme() sets gtsummary theme", {
  skip_if_not_installed("gtsummary")
  on.exit(gtsummary::reset_gtsummary_theme(), add = TRUE)

  gtsummary::reset_gtsummary_theme()
  suppressMessages(use_jama_theme())

  current_theme <- gtsummary::get_gtsummary_theme()
  expect_true(length(current_theme) > 0)
})

test_that("use_jama_theme() returns theme invisibly", {
  skip_if_not_installed("gtsummary")
  on.exit(gtsummary::reset_gtsummary_theme(), add = TRUE)

  result <- suppressMessages(use_jama_theme())
  expect_type(result, "list")
})

test_that("use_jama_theme() can be called multiple times", {
  skip_if_not_installed("gtsummary")
  on.exit(gtsummary::reset_gtsummary_theme(), add = TRUE)

  expect_no_message(use_jama_theme())
  expect_no_message(use_jama_theme())
})

test_that("use_jama_theme(quiet = FALSE) emits a message", {
  skip_if_not_installed("gtsummary")
  on.exit(gtsummary::reset_gtsummary_theme(), add = TRUE)

  expect_message(
    use_jama_theme(quiet = FALSE),
    "Applied JAMA compact theme"
  )
})
