% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nchar.R
\name{nchar}
\alias{nchar}
\alias{nzchar}
\title{Get Length or Width of Strings}
\usage{
nchar(x, type = "chars", allowNA = FALSE, keepNA = TRUE)

nzchar(x, keepNA = TRUE)
}
\arguments{
\item{x}{character vector or an object coercible to}

\item{type}{\code{"chars"} gives the number of code points,
\code{"width"} estimates the string width,
\code{"bytes"} computes the number of bytes}

\item{allowNA}{not used (with a warning if attempting to do so) [DEPRECATED]}

\item{keepNA}{if \code{FALSE}, missing values will
be treated as \code{"NA"} strings; otherwise, the corresponding outputs
will be missing as well [DEPRECATED]}
}
\value{
\code{nchar} returns an integer vector.

\code{nzchar} returns a logical vector, where \code{TRUE} indicates
that the corresponding string is of non-zero length (i.e., non-empty).
}
\description{
\code{nchar} computes the number of code points, bytes used, or
estimated total width of strings in a character vector.
\code{nzchar} indicates which strings are empty.
}
\details{
String width might be useful when displaying text using a monospaced font.
}
\section{Differences from Base R}{

Replacement for base \code{\link[base]{nchar}} and \code{\link[base]{nzchar}}
implemented with \code{\link[stringi]{stri_length}},
\code{\link[stringi]{stri_width}},
\code{\link[stringi]{stri_numbytes}},
and \code{\link[stringi]{stri_isempty}}.

\itemize{
\item \code{keepNA} does not default to \code{TRUE}, and hence
    missing values are treated as \code{"NA"} strings
    \bold{[fixed here]}
\item some emojis, combining characters and modifiers (e.g., skin tones)
   are not recognised properly
    \bold{[fixed here]}
\item only the \code{names} attribute is propagated
    \bold{[fixed here]}
}
}

\examples{
x <- c(
    "\U0001F4A9",
    "\U0001F64D\U0001F3FC\U0000200D\U00002642\U0000FE0F",
    "\U0001F64D\U0001F3FB\U0000200D\U00002642",
    "\U000026F9\U0001F3FF\U0000200D\U00002640\U0000FE0F",
    "\U0001F3F4\U000E0067\U000E0062\U000E0073\U000E0063\U000E0074\U000E007F"
)
print(x)
base::nchar(x, "width")
stringx::nchar(x, "width")


}
\seealso{
The official online manual of \pkg{stringx} at \url{https://stringx.gagolewski.com/}

Related function(s): \code{\link{sprintf}}, \code{\link{substr}},
    \code{\link{strtrim}}
}
\author{
\href{https://www.gagolewski.com/}{Marek Gagolewski}
}
