% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agreement.R
\name{agreement}
\alias{agreement}
\title{Agreement-based Measures for Clustering}
\usage{
agreement(predicted, actual, method = "cRand", na_as_cluster = TRUE)
}
\arguments{
\item{predicted}{a vector with predicted cluster labels.}

\item{actual}{the known cluster labels (ground truth).}

\item{method}{the used method (see \code{\link[clue:cl_agreement]{clue::cl_agreement()}}).}

\item{na_as_cluster}{logical; should \code{NA} labels (noise points) be considered its own cluster?}
}
\description{
Calculates the agreement between two partitions, typically the known actual cluster labels
and the predicted cluster labels.
}
\details{
This convenience function is an interface to \code{\link[clue:cl_agreement]{clue::cl_agreement()}}. See \code{methods} in that man page
for a list of available methods. A measure typically used for clustering is the corrected Rand index
(also called adjusted Rand index). Numbers close to 1 indicate a very good agreement.
}
\examples{
# Perfect agreement (1 and 2 are just switched)
actual <- c(2, 2, 1, 3, 2, NA)
predicted <- c(1, 1, 2, 3, 1, NA)
agreement(actual, predicted)

# No agreement
predicted <- sample(predicted)
agreement(actual, predicted)
}
\references{
Hornik K (2005). A CLUE for CLUster Ensembles. \emph{Journal of Statistical Software}, \emph{14}(12).
\doi{10.18637/jss.v014.i12}
}
