% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/depletion_max_distance.R
\name{depletion_max_distance}
\alias{depletion_max_distance}
\title{Calculate maximum distance at which streamflow depletion will exceed a user-selected threshold. Note that this only considers a single stream - depletion apportionment does not occur.}
\usage{
depletion_max_distance(
  Qf_thres = 0.01,
  d_interval = 100,
  d_min = NULL,
  d_max = 5000,
  method = "glover",
  t,
  S,
  Tr,
  ...
)
}
\arguments{
\item{Qf_thres}{streamflow depletion fraction (\code{Qf}) threshold used to define maximum distance. Defaults to 0.01 (1\%).}

\item{d_interval}{interval to use for testing; this defines the spatial resolution at which output will be returned [L]}

\item{d_min}{minimum search distance [L]. If `Qf` < `Qf_thres` at `d_min`, function will return `d_min` and a warning.
If `d_min`=NULL (default), `d_min` will be set to `d_interval'`}

\item{d_max}{maximum search distance [L]. If `Qf` > `Qf_thres` at `d_max`, function will return `d_max` and a warning.}

\item{method}{analytical solution to use (options= 'glover', 'hunt'). Defaults to 'glover'.}

\item{t}{time you want output for [T]}

\item{S}{aquifer storage coefficient (specific yield if unconfined; storativity if confined)}

\item{Tr}{aquifer transmissivity [L2/T]}

\item{...}{any other inputs required for your \code{method} of choice; for example, \code{hunt} needs \code{lmda} (streambed conductance)}
}
\value{
A numeric of the distance at which streamflow depletion fraction (\code{Qf}) drops below the threshold at time `t`.
}
\description{
Calculate maximum distance at which streamflow depletion will exceed a user-selected threshold. Note that this only considers a single stream - depletion apportionment does not occur.
}
\details{
This function is useful for the 'Expanding' stream proximity criteria described in Zipper et al. (2018).
}
\examples{
depletion_max_distance(method = "glover", t = 730, S = 0.1, Tr = 100)
depletion_max_distance(Qf_thres = 0.001, method = "glover", t = 730, S = 0.1, Tr = 100)
depletion_max_distance(Qf_thres = 0.001, method = "hunt", t = 730, S = 0.1, Tr = 100, lmda = 0.01)
depletion_max_distance(Qf_thres = 0.001, method = "hunt", t = 7300, S = 0.1, Tr = 100, lmda = 0.01)
}
\references{
Zipper, SC, T Gleeson, B Kerr, JK Howard, MM Rohde, J Carah, J Zimmerman (2018). Rapid and accurate estimates
of streamflow depletion caused by groundwater pumping using analytical depletion functions. EarthArXiv.
doi:10.31223/osf.io/uqbd7.
}
