% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{ran_round}
\alias{ran_round}
\title{Random Rounding of Numbers}
\usage{
ran_round(x)
}
\arguments{
\item{x}{(\code{numeric})\cr a numeric vector.}
}
\value{
An integer vector.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

A number \eqn{x} is rounded to integer \eqn{y} according to the following
rule:
\deqn{y = \left\lfloor{x}\right\rfloor + I(u < (x - \left\lfloor{x}\right\rfloor)),}
where function \eqn{I:\{TRUE, FALSE\} \to \{0, 1\}}, is defined as:
\deqn{
 I(x) = \begin{cases}
 0,  & x \text{ is } FALSE \\
 1, & x \text{ is } TRUE,
 \end{cases}
}
and \eqn{u} is number that is generated from \code{Uniform(0, 1)} distribution.
}
\examples{
x <- c(4.5, 4.1, 4.9)
set.seed(5)
ran_round(x) # 5 4 4
set.seed(6)
ran_round(x) # 4 4 5
}
