% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadMsg.R
\name{loadMsg}
\alias{loadMsg}
\title{loadMsg}
\usage{
loadMsg(
  files,
  .domain = getOption("stranslate.domain"),
  .lang = "en",
  .silent = TRUE,
  .overwrite = FALSE
)
}
\arguments{
\item{files}{character: names of text file(s) with translated messages}

\item{.domain}{character: domain namesd (default: \code{getOption("stranslate.domain")})}

\item{.lang}{character: default language (default: 'en')}

\item{.silent}{logical: should outputs be displayed during the loading process and then \code{listMsg()} be called?}

\item{.overwrite}{logical: should keys be overwritten (default: \code{FALSE})}
}
\value{
invisibly the current message environment
}
\description{
Loads translated messages from one (or more) file into package environment. For details read the vignette \code{vignette("stranslate")}.
}
\examples{
# note "messages/messages.txt" contains only english and german ;)
loadMsg(system.file("messages/messages.txt", package="stranslate"), .overwrite=TRUE) # avoid warning
# english
getMsg(ROUND=0, .lang="en")
getMsg(ROUND=1, .lang="en")
getMsg(ROUND=2, .lang="en")
# english
getMsg(ROUND=0, .lang="de")
getMsg(ROUND=1, .lang="de")
getMsg(ROUND=2, .lang="de")
# default language or if not available then english 
getMsg(ROUND=0)
getMsg(ROUND=1)
getMsg(ROUND=2)
}
