% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str2str_functions.R
\name{rbind<-}
\alias{rbind<-}
\title{Add Rows to Data Objects}
\usage{
rbind(data, after = nrow(data), row.nm = NULL, overwrite = TRUE) <- value
}
\arguments{
\item{data}{data.frame or matrix of data.}

\item{after}{either an integer vector with length 1 or a character vector of
length 1 specifying where to add \code{value}. If an integer vector, it is the
position of a row. If a character vector it is the row with that name.
Similar to \code{append}, use 0L if you want the added rows to be first.}

\item{row.nm}{character vector of length equal to \code{NROW(value)} that
specifies the rownames of \code{value} once added to \code{data} as columns.
This is an optional argument that defaults to NULL where the pre-existing rownames
of \code{value} are used.}

\item{overwrite}{logical vector of length 1 specifying whether rows from
\code{value} or \code{row.nm} should overwrite rows in \code{data} with the
same rownames. Note, if \code{overwrite} = FALSE, R will prevent repeat rownames
by adding "1" to the end of the repeat rownames similar to \code{rbind}.}

\item{value}{data.frame, matrix, or atomic vector to be added as rows to
\code{data}. If a data.frame or matrix, it must have the same ncol as \code{data}.
If an atomic vector, it must have length equal to ncol of \code{data}.}
}
\value{
Like other similar functions (e.g., \code{`names<-`} and \code{`[<-`}),
\code{`rbind<-`} does not appear to have a return object. However, it technically
does as a side effect. The argument \code{data} will have been changed such that
\code{value} has been added as rows. If a traditional return object is desired,
and no side effects, then it can be called like a traditional function:
dat2 <- `rbind<-`(dat1, value = add1).
}
\description{
\code{`rbind<-`} adds rows to data objects as a side effect. The purpose of
the function is to replace the need to use dat2 <- rbind(dat1, add1);
dat3 <- rbind(dat2, add2); dat4 <- rbind(dat3, add3), etc. For data.frames,
it functions similarly to \code{`[<-.data.frame`}, but allows you to specify the
location of the rows similar to \code{append} (vs. \code{c}) and overwrite
rows with the same rownames. For matrices, it offers more novel functionality
since \code{`[<-.matrix`} does not exist.
}
\details{
Some traditional R folks may find this function uncomfortable. R is famous for limiting
side effects, except for a few notable exceptions (e.g., \code{`[<-`} and \code{`names<-`}).
Part of the reason is that side effects can be computationally inefficient in R.
The entire object often has to be re-constructed and re-saved to memory. For
example, a more computationally efficient alternative to rbind(dat) <- add1;
rbind(dat) <- add2; rbind(dat) <- add3 is dat1 <- do.call(what = rbind,
args = list(dat, add1, add2, add3)). However, \code{`rbind<-`} was not created
for R programming use when computational efficiency is valued; it is created
for R interactive use when user convenience is valued.

Similar to \code{`rbind`}, \code{`rbind<-`} works with both data.frames and matrices.
This is because \code{`rbind`} is a generic function with a default method that
works with matrices and a data.frame method that works with data.frames. Similar
to \code{`rbind`}, if rownames of \code{value} are not given and \code{row.nm}
is left NULL, then the rownames of the return object are automatically created
and can be dissatisfying.
}
\examples{
attitude2 <- attitude
rbind(attitude2) <- colMeans(attitude2) # defaults to rownames = as.character(nrow(`data`) + 1)
attitude2 <- attitude2[!(`\%in\%`(x = row.names(attitude2), table = "31")), ] # logical subset
rbind(attitude2, row.nm = "mean") <- colMeans(attitude2)
attitude2 <- attitude2[-1*(match(x = "mean", table = row.names(attitude2))), ] # position subset
rbind(attitude2, after = "10", row.nm = c("mean","sum")) <-
   rbind(colMeans(attitude2), colSums(attitude2)) # `value` as a matrix
attitude2 <- attitude2[grep(pattern = "mean|sum", x = row.names(attitude2),
   invert = TRUE), ] # rownames subset
attitude2 <- `rbind<-`(data = attitude2, value = colMeans(attitude2)) # traditional call
attitude2 <- as.matrix(attitude, rownames.force = TRUE) # as.matrix.data.frame
rbind(attitude2, after = "10", row.nm = "mean") <- colMeans(attitude2) # `data` as a matrix
# using overwrite
mtcars2 <- mtcars
rownames(mtcars2)
add <- mtcars[c("Mazda RX4","Mazda RX4 Wag","Datsun 710"), ]*11
rbind(mtcars2, overwrite = TRUE) <- add
mtcars2 <- mtcars
rbind(mtcars2, overwrite = FALSE) <- add
}
