% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_session_meetings.R
\name{get_session_meetings}
\alias{get_session_meetings}
\title{Retrieve all meetings for a specified parliamentary session}
\usage{
get_session_meetings(sessionid = NA, good_manners = 0)
}
\arguments{
\item{sessionid}{Character string indicating the id of the session to request all votes from}

\item{good_manners}{Integer. Seconds delay between calls when making multiple calls to the same function}
}
\value{
A data.frame with the following variables:\tabular{ll}{
    \tab  \cr
   \strong{response_date} \tab Date of data retrieval \cr
   \strong{version} \tab Data version from the API \cr
   \strong{session_id} \tab Session id \cr
   \strong{agenda_number} \tab Agenda number within the session \cr
   \strong{footnote} \tab Footnotes for the meeting \cr
   \strong{meeting_id} \tab Meeting id \cr
   \strong{no_meeting_text} \tab Description of why there was no meeting, if relevant \cr
   \strong{evening_meeting} \tab Whether the meeting was an evening meeting or not \cr
   \strong{note} \tab Note for the meeting \cr
   \strong{meeting_date} \tab Date the meeting took place \cr
   \strong{meeting_order} \tab Indicator for meeting order \cr
   \strong{meeting_place} \tab Where the meeting took place \cr
   \strong{transcript_id} \tab Id for transcript (usually empty) \cr
   \strong{additional_agenda} \tab Logical indicator for whether there was additional agenda to the meeting \cr
}
}
\description{
A function for retrieving meetings from a specific parliamentary session
}
\examples{

\dontrun{

meet <- get_session_meetings("2013-2014")
head(meet)

}
 
}
\seealso{
\link{get_meeting_agenda} \link{get_question_hour}
}
