% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FrequencyTable.R
\name{FrequencyTable}
\alias{FrequencyTable}
\alias{print.FrequencyTable}
\alias{plot.FrequencyTable}
\alias{summary.FrequencyTable}
\title{Create a FrequencyTable}
\usage{
FrequencyTable(data)

\method{print}{FrequencyTable}(x, ...)

\method{plot}{FrequencyTable}(x, ...)

\method{summary}{FrequencyTable}(object, ...)
}
\arguments{
\item{data}{vector of raw scores. Double values are coerced to integer}

\item{x}{A \code{FrequencyTable} object}

\item{...}{further arguments passed to or from other methods.}

\item{object}{A \code{FrequencyTable} object}
}
\value{
FrequencyTable object. Consists of:
\itemize{
\item table: data.frame with number of observations (\code{n}), frequency in sample
(\code{freq}), quantile (\code{quan}) and normalized Z-score (\code{Z}) for each point in
raw score
\item status: list containing the total number of simulated observations (\code{n})
and information about raw scores range completion (\code{range}): complete or incomplete
}

\code{data.frame} of descriptive statistcs
}
\description{
Normalizes the distribution of raw scores. It can be used to construct
\code{\link[=ScoreTable]{ScoreTable()}} with the use of some \code{\link[=StandardScale]{StandardScale()}} to normalize and
standardize the raw discrete scores.

\code{plot.FrequencyTable} method requires \code{ggplot2} package to be installed.
}
\seealso{
\code{\link[=SimFrequencyTable]{SimFrequencyTable()}}
}
