% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stddiff_spark.R
\name{stddiff.numeric}
\alias{stddiff.numeric}
\title{Compute Standardized Differences for Numeric Variables (Spark)}
\usage{
stddiff.numeric(data, gcol, vcol, verbose = FALSE)
}
\arguments{
\item{data}{A Spark DataFrame (\code{tbl_spark}) containing the variables.}

\item{gcol}{Integer; column index of the binary grouping variable.}

\item{vcol}{Integer vector; column indices of the numeric variables to analyze.}

\item{verbose}{Logical; if TRUE, prints progress messages. Default is FALSE.}
}
\value{
A numeric matrix with one row per variable and columns:
\itemize{
\item \code{mean.c}: Mean in control group
\item \code{sd.c}: Standard deviation in control group
\item \code{mean.t}: Mean in treatment group
\item \code{sd.t}: Standard deviation in treatment group
\item \code{missing.c}: Number of missing values in control group
\item \code{missing.t}: Number of missing values in treatment group
\item \code{stddiff}: Standardized difference
\item \code{stddiff.l}: Lower bound of 95\% confidence interval
\item \code{stddiff.u}: Upper bound of 95\% confidence interval
}
}
\description{
Calculates standardized differences for continuous numeric variables using a
Spark DataFrame. Equivalent to \code{stddiff::stddiff.numeric} but operates on Spark data.
}
\details{
The standardized difference for continuous variables is computed as:
\deqn{d = \frac{|\bar{x}_t - \bar{x}_c|}{\sqrt{(s_t^2 + s_c^2)/2}}}
where \eqn{\bar{x}} represents means and \eqn{s^2} represents variances.

This is equivalent to Cohen's d with pooled standard deviation.
}
\examples{
\dontshow{if (requireNamespace("sparklyr", quietly = TRUE) && interactive()) withAutoprint(\{ # examplesIf}
sc <- sparklyr::spark_connect(master = "local")

spark_df <- sparklyr::copy_to(sc, mtcars)

result <- stddiff.numeric(
  data = spark_df,
  gcol = 8,          # column index of grouping variable
  vcol = c(1, 2, 5)  # columns of numeric variables
)

sparklyr::spark_disconnect(sc)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link{stddiff.binary}}, \code{\link{stddiff.category}}
}
