% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inference.R
\name{inference}
\alias{inference}
\title{Hypothesis tests and confidence intervals}
\usage{
inference(
  y,
  x = NULL,
  data,
  type = c("ci", "ht"),
  statistic = c("mean", "median", "proportion"),
  success = NULL,
  order = NULL,
  method = c("theoretical", "simulation"),
  null = NULL,
  alternative = c("less", "greater", "twosided"),
  sig_level = 0.05,
  conf_level = 0.95,
  boot_method = c("perc", "se"),
  nsim = 15000,
  seed = NULL,
  verbose = TRUE,
  show_var_types = verbose,
  show_summ_stats = verbose,
  show_eda_plot = verbose,
  show_inf_plot = verbose,
  show_res = verbose
)
}
\arguments{
\item{y}{Response variable, can be numerical or categorical}

\item{x}{Explanatory variable, categorical (optional)}

\item{data}{Name of data frame that y and x are in}

\item{type}{of inference; "ci" (confidence interval) or "ht" (hypothesis test)}

\item{statistic}{parameter to estimate: mean, median, or proportion}

\item{success}{which level of the categorical variable to call "success", i.e. do inference on}

\item{order}{when x is given, order of levels of x in which to subtract parameters}

\item{method}{of inference; "theoretical" (CLT based) or "simulation" (randomization/bootstrap)}

\item{null}{null value for a hypothesis test}

\item{alternative}{direction of the alternative hypothesis; "less","greater", or "twosided"}

\item{sig_level}{significance level, value between 0 and 1 (used only for ANOVA to determine if posttests are necessary)}

\item{conf_level}{confidence level, value between 0 and 1}

\item{boot_method}{bootstrap method; "perc" (percentile) or "se" (standard error)}

\item{nsim}{number of simulations}

\item{seed}{seed to be set, default is NULL}

\item{verbose}{whether output should be verbose or not, default is TRUE}

\item{show_var_types}{print variable types, set to verbose by default}

\item{show_summ_stats}{print summary stats, set to verbose by default}

\item{show_eda_plot}{print EDA plot, set to verbose by default}

\item{show_inf_plot}{print inference plot, set to verbose by default}

\item{show_res}{print results, set to verbose by default}
}
\value{
Results of inference task performed
}
\description{
Hypothesis tests and confidence intervals
}
\examples{
data(tapwater)

# Calculate 95\% CI using quantiles using a Student t distribution
inference(tthm, data=tapwater,
                statistic="mean", 
                type="ci",
                method="theoretical")
                
inference(tthm, data=tapwater,
                statistic="mean", 
                type="ci",
                boot_method = "perc",
                method="simulation")
                
# Inference for a proportion
# Calculate 95\% confidence intervals for the proportion of atheists

data("atheism")
library("dplyr")
us12 <- atheism \%>\%
        filter(nationality == "United States" , atheism$year == "2012")
inference(y = response, data = us12, statistic = "proportion",
          type = "ci",
          method = "theoretical", 
          success = "atheist")
                
}
