% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{sim.ci.mean.ps}
\alias{sim.ci.mean.ps}
\title{Simulates confidence interval coverage probability for a paired-samples mean
difference}
\usage{
sim.ci.mean.ps(alpha, n, sd2, cor, dist1, dist2, rep)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{n}{sample size}

\item{sd2}{population standard deviation at level 2}

\item{cor}{population correlation of paired observations}

\item{dist1}{type of distribution at level 1 (1, 2, 3, 4, or 5)}

\item{dist2}{type of distribution at level 2 (1, 2, 3, 4, or 5)
\itemize{
\item 1 = Gaussian (skewness = 0 and excess kurtosis = 0)
\item 2 = platykurtic (skewness = 0 and excess kurtosis = -1.2)
\item 3 = leptokurtic (skewness = 0 and excess kurtosis = 6)
\item 4 = moderate skew (skewness = 1 and excess kurtosis = 1.5)
\item 5 = large skew (skewness = 2 and excess kurtosis = 6)
}}

\item{rep}{number of Monte Carlo samples}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Coverage - probability of confidence interval including population mean difference
\item Lower Error - probability of lower limit greater than population mean difference
\item Upper Error - probability of upper limit less than population mean difference
\item Ave CI Width - average confidence interval width
}
}
\description{
Performs a computer simulation of confidence interval performance for a
population mean difference in a paired-samples design. Sample data for the two
levels of the within-subjects factor can be generated from bivariate population
distributions with five different marginal distributions. All distributions
are scaled to have a standard deviation of 1.0 at level 1. Bivariate random
data with specified marginal skewness and kurtosis are generated using the
unonr function in the mnonr package.
}
\examples{
sim.ci.mean.ps(.05, 30, 1.5, .7, 4, 5, 1000)

# Should return (within sampling error):
# Coverage Lower Error Upper Error Ave CI Width
#  0.94415     0.04525      0.0106    0.7818518


}
