% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{expert1}
\alias{expert1}
\title{Sensory Evaluation Data from Expert 1}
\format{
A data frame with 6 rows (Wine1–Wine6) and 3 sensory attributes:
\describe{
\item{fruity}{Intensity of fruity aromas.}
\item{woody}{Intensity of woody/aged aromas.}
\item{coffee}{Perceived coffee-like notes.}
}
}
\usage{
data(expert1)
}
\description{
This dataset contains the ratings provided by Expert 1 for six wine samples.
Each wine is evaluated according to three sensory attributes commonly used
in descriptive analysis: \emph{fruity}, \emph{woody}, and \emph{coffee}.
The dataset is typically used in STATIS and multitable analyses to illustrate
how different experts evaluate the same set of products.
}
\examples{
data(expert1)
expert1

}
\references{
Abdi, H., & Valentin, D. (2007). The STATIS method. Encyclopedia of measurement and statistics, 955-962.
}
\keyword{datasets}
