% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/staticrypt.r
\name{staticryptr}
\alias{staticryptr}
\title{Staticrypt Wrapper Function with Command Print Option and User-Specified String}
\usage{
staticryptr(
  files,
  directory = NULL,
  recursive = FALSE,
  password = NULL,
  short = FALSE,
  decrypt = FALSE,
  remember = NULL,
  salt = NULL,
  share = NULL,
  share_remember = FALSE,
  config = NULL,
  template = NULL,
  template_button = NULL,
  template_color_primary = NULL,
  template_color_secondary = NULL,
  template_instructions = NULL,
  template_error = NULL,
  template_placeholder = NULL,
  template_remember = NULL,
  template_title = NULL,
  template_toggle_hide = NULL,
  template_toggle_show = NULL,
  print_cmd = FALSE,
  user_string = NULL
)
}
\arguments{
\item{files}{Character. One or more filenames to encrypt/decrypt.}

\item{directory}{Character. Directory where the generated files will be saved (default: NULL).}

\item{recursive}{Boolean. Whether to recursively encrypt the input directory (default: FALSE).}

\item{password}{Character. Password for encryption (default: NULL, prompts if empty).}

\item{short}{Boolean. Hide "short password" warning (default: FALSE).}

\item{decrypt}{Boolean. Flag to decrypt files (default: FALSE).}

\item{remember}{Integer. Expiration in days for "Remember me" checkbox (default: NULL).}

\item{salt}{Character. 32-character hexadecimal string used as salt (default: NULL).}

\item{share}{Character. URL for auto-decrypting link (default: NULL).}

\item{share_remember}{Boolean. Auto-enable "Remember me" in the share link (default: FALSE).}

\item{config}{Character. Path to the config file (default: NULL).}

\item{template}{Character. Path to custom HTML template (default: NULL).}

\item{template_button}{Character. Label for the decrypt button (default: NULL).}

\item{template_color_primary}{Character. Primary color for the button (default: NULL).}

\item{template_color_secondary}{Character. Secondary color for the background (default: NULL).}

\item{template_instructions}{Character. Special instructions for the user (default: NULL).}

\item{template_error}{Character. Error message on wrong password (default: NULL).}

\item{template_placeholder}{Character. Placeholder for password input (default: NULL).}

\item{template_remember}{Character. Label for "Remember me" checkbox (default: NULL).}

\item{template_title}{Character. Title for the HTML page (default: NULL).}

\item{template_toggle_hide}{Character. Alt text for hiding the password (default: NULL).}

\item{template_toggle_show}{Character. Alt text for showing the password (default: NULL).}

\item{print_cmd}{Boolean. Whether to print the resulting command instead of executing it (default: FALSE).}

\item{user_string}{Character. A user-specified string to be appended to the command (default: NULL).}
}
\value{
Executes the Staticrypt CLI with the specified options or prints the command if \code{print_cmd} is \code{TRUE}.
}
\description{
This function is an R wrapper for the Staticrypt CLI tool. It allows users to encrypt or decrypt files using various customizable options, includes type checking for each argument, offers the option to print the resulting command without executing it, and allows the inclusion of a user-specified string.
}
\examples{
# Encrypt a file with a password
# `print_cmd = TRUE` Only outputs the command to be passed to `system()`
staticryptr(
  "index.html",
  password = "yourpassword",
  print_cmd = TRUE
)

# Decrypt a file (assuming you have the correct configuration)
staticryptr(
  "index.html",
  decrypt = TRUE,
  print_cmd = TRUE
)

# Encrypt multiple files with custom options
staticryptr(
  files = c("page1.html", "page2.html"),
  password = "securepassword",
  template = "custom_template.html",
  template_color_primary = "#3498db",
  template_instructions = "Enter the password to access the page.",
  print_cmd = TRUE
)

# Encrypt a directory recursively
staticryptr(
  files = "_output/",
  directory = ".",
  password = "yourverylongpassword",
  short = TRUE,
  recursive = TRUE,
  print_cmd = TRUE
)
}
