% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phase2_states_chart.R
\name{panel_st_raw}
\alias{panel_st_raw}
\title{Create a space time visualization as a Gantt chart}
\usage{
panel_st_raw(
  data = NULL,
  ST.Outliers = data$config$st$outliers,
  base_size = data$config$base_size,
  expand_x = data$config$expand,
  expand_y = data$config$st$expand,
  selected_nodes = data$config$selected_nodes,
  labels = data$config$st$labels,
  alpha = data$config$st$alpha,
  idleness = data$config$st$idleness,
  taskdeps = data$config$st$tasks$active,
  tasklist = data$config$st$tasks$list,
  levels = data$config$st$tasks$levels,
  makespan = data$config$st$makespan,
  abe = data$config$st$abe$active,
  pmtoolbounds = data$config$pmtool$bounds$active,
  cpb = data$config$st$cpb,
  cpb_mpi = data$config$st$cpb_mpi$active,
  legend = data$config$st$legend,
  x_start = data$config$limits$start,
  x_end = data$config$limits$end,
  drop_small = data$config$st$drop_small,
  runtime = FALSE
)
}
\arguments{
\item{data}{starvz_data with trace data}

\item{ST.Outliers}{enable/disable the anomalous task highlighting}

\item{base_size}{base_size base font size}

\item{expand_x}{expand size for scale_x_continuous padding}

\item{expand_y}{expand size for scale_y_continuous padding}

\item{selected_nodes}{select only some nodes in some plots}

\item{labels}{labels: [ALL, 1CPU_per_NODE, 1GPU_per_NODE, FIRST_LAST, NODES_only, NODES_1_in_10, 1CPU_1GPU, ALL_nompi]}

\item{alpha}{alpha value for non-anomalous tasks}

\item{idleness}{enable/disable idleness percentages in the plot}

\item{taskdeps}{enable/disable task deps path highlighting}

\item{tasklist}{list of JobIds to highlight the dependencies}

\item{levels}{number of dependencies to be shown}

\item{makespan}{enable/disable application makespan at the end of the plot}

\item{abe}{enable/disable ABE metric}

\item{pmtoolbounds}{enable/disable pmtool theoretical bounds}

\item{cpb}{enable/disable critical path bound makespan metric}

\item{cpb_mpi}{enable/disable critical path bound makespan considering MPI}

\item{legend}{enable/disable legends}

\item{x_start}{X-axis start value}

\item{x_end}{X-axis end value}

\item{drop_small}{Drop states smaller then this value}

\item{runtime}{TODO I think we should create a separated function for it}
}
\value{
A ggplot object
}
\description{
Use the Application trace data to plot the task computations by ResourceId
over the execution time.
}
\examples{
\donttest{
panel_st_raw(data = starvz_sample_lu)
}
}
