% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{hosp_agg}
\alias{hosp_agg}
\title{Aggregated hospitalization data}
\format{
\subsection{\code{hosp_agg}}{

A data frame with 31,040 rows and 10 columns:
\describe{
\item{yr}{Character vector representing the observation year for each row.}
\item{county}{Character vector containing county names}
\item{cohort}{Character vector identifying the intervention cohort to which each county belongs. Takes values 0, 5, 6, 7, or 8, corresponding to counties that implemented the intervention not at all or during 2015, 2016, 2017, or 2018, respectively. Invariant within counties.}
\item{intervention_yr}{Character vector containing the year during which \code{intervention_dt} takes place}
\item{pct_hospitalized}{Numeric vector containing the proportion of individuals in each county-year who were hospitalized.}
\item{n_enr}{Integer indicating the number of individuals living in each county during the curent year.}
\item{mean_age}{Numeric containing mean ages among individuals living in each county during the current year.}
\item{pct_fem}{Numeric containing the proportion of individuals in each county-year who are female.}
\item{pct_cmb}{Numeric containing the proportion of individuals in each county-year who have comorbidities.}
}
}
}
\usage{
hosp_agg
}
\description{
A simulated data set of 15 counties, 11 of which implemented a policy
intervention during 2015 - 2018 to reduce hospitalizations. The data set is
longitudinal and aggregated to county-year.
}
\details{
Consider a policy intervention designed to reduce inpatient hospitalizations
in 15 counties. This longitudinal data set has one row per county-year and
includes aggregated measures of individuals' ages, sexes, and comorbidities,
and a column indicating proportion of individuals who were hospitalized
during the current year.

The column \code{intervention_yr} tells us the year during which each county
implemented the intervention. If \code{intervention_yr} is \code{NA}, we can conclude
that the county never implemented the intervention. Among the 15 counties, 3
implemented the intervention in 2015; 2 counties implemented in 2016; 5
counties implemented in 2017; 1 county implemented in 2018; and 4 counties
did not implement the intervention at all during the study period, which runs
for 11 years, from 2010 through 2020.
}
\keyword{datasets}
