% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers_xgboost.R
\name{xgboost_train}
\alias{xgboost_train}
\title{Train xgboost model}
\usage{
xgboost_train(params, data, nrounds, ...)
}
\arguments{
\item{params}{A list of parameters.}

\item{data}{Training data.}

\item{nrounds}{The Maximum number of boosting iterations.}

\item{...}{Additional parameters.}
}
\value{
A model object.
}
\description{
Train xgboost model
}
\examples{
\dontshow{if (is_installed_xgboost()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
sim_data <- msaenet::msaenet.sim.binomial(
  n = 100,
  p = 10,
  rho = 0.6,
  coef = rnorm(5, mean = 0, sd = 10),
  snr = 1,
  p.train = 0.8,
  seed = 42
)

x_train <- xgboost_dmatrix(sim_data$x.tr, label = sim_data$y.tr)

fit <- xgboost_train(
  params = list(
    objective = "binary:logistic",
    eval_metric = "auc",
    max_depth = 3,
    eta = 0.1
  ),
  data = x_train,
  nrounds = 100,
  nthread = 1
)

fit
\dontshow{\}) # examplesIf}
}
