% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sttknorm.R
\name{sttknorm}
\alias{sttknorm}
\title{Standardizes Statokinesigrams}
\usage{
sttknorm(dados)
}
\arguments{
\item{dados}{data frame with two columns "x" and "y"}
}
\value{
The normalized statokinesigram \code{stknorm}.
}
\description{
confines a given statokinesigram in a circumference of radius equal to 1, without spatially distorting its shape. The circumference contains 95 percent of statokinesigram's points.
}
\details{
'dados' is a data frame containing two columns named "x" and "y". The pairs (x, y) are the coordinates of the center of pressure acquired in a period of time.
}
\examples{
x <- c(1,3,7,5,9,4,3,6,8,2,8,9,4,5,7,3,4,7,9,3,2,5,3,4,8,2,9,7,4,2)
y <- c(6,3,9,1,3,7,4,9,6,1,7,3,9,7,2,6,3,4,8,1,9,3,6,8,1,6,2,9,8,3)

COP <- data.frame(x, y)

COPnorm <- sttknorm(COP)


}
\seealso{
\code{\link[stabilo]{sttkarea}}, \code{\link[stabilo]{sttklength}}
}
\author{
Jose Magalhaes de Oliveira
}
