% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ccme_data.R
\docType{data}
\name{ccme_data}
\alias{ccme_data}
\title{CCME Species Sensitivity Data}
\format{
An object of class \code{tbl_df} (inherits from \code{tbl},
\code{data.frame}) with 144 rows and 5 columns.
}
\usage{
ccme_data
}
\description{
Species Sensitivity Data from the Canadian Council of Ministers of the
Environment. The taxonomic groups are Amphibian, Fish, Invertebrate and
Plant. Plants includes freshwater algae.
}
\details{
Additional information on each of the chemicals is available from the CCME
website.

\describe{
\item{boron}{\insertRef{Boron}{ssddata}}
\item{cadmium}{\insertRef{Cadmium}{ssddata}}
\item{chloride}{\insertRef{Chloride}{ssddata}}
\item{endosulfan}{\insertRef{Endosulfan}{ssddata}}
\item{glyphosate}{\insertRef{Glyphosate}{ssddata}}
\item{uranium}{\insertRef{Uranium}{ssddata}}
\item{silver}{\insertRef{Silver}{ssddata}}
}

The columns are as follows:

\describe{
\item{Chemical}{The chemical (chr).}
\item{Species}{The species binomial name (chr).}
\item{Conc}{The chemical concentration (dbl).}
\item{Group}{The taxonomic group (fct).}
\item{Units}{The units of Conc (chr).}
}
}
\examples{

head(ccme_data)

}
\keyword{datasets}
