% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_by_mask.R
\name{select_by_mask}
\alias{select_by_mask}
\title{Select by Mask}
\usage{
select_by_mask(data, intMask)
}
\arguments{
\item{data}{A numeric matrix in tidy form}

\item{intMask}{An Integer vector whose length equals number of columns in data}
}
\value{
A matrix containing the columns of data for which intMask is 1
}
\description{
Select columns from a matrix using an integer bitmap
}
\details{
Selects columns from a matrix.  A column is included in the output when the
corresponding mask value is 1.
}
\examples{
e12 <- embed(mgls, 13)
tn <- e12[ , 1]
pn <- e12[ ,2:13]
msk <- integer(12)
msk[c(1,2,3,4,6,7,9)] <- 1  # select these columns
p <- select_by_mask(pn, msk)
gamma_test(predictors = p, target = tn)

msk <- int_to_intMask(15, 12)     # pick out the first four columns
p <- select_by_mask(pn, msk)
gamma_test(predictors = p, target = tn)
}
