% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moving_window_search.R
\name{moving_window_search}
\alias{moving_window_search}
\title{Moving Window Search}
\usage{
moving_window_search(
  predictors,
  target,
  window_size = 40,
  by = 1,
  plot = TRUE,
  caption = "",
  show = "Gamma"
)
}
\arguments{
\item{predictors}{A Numeric vector or matrix whose columns are proposed inputs
to a predictive function}

\item{target}{A Numeric vector, the output variable that is to be predicted}

\item{window_size}{Integer width of the window that will move through the data}

\item{by}{The increment between successive window starts}

\item{plot}{Logical, set this to FALSE if you don't want the plot}

\item{caption}{Character string, caption for plot}

\item{show}{Character string, if it equals "vratio", vratios will be plotted,
otherwise Gamma is plotted}
}
\value{
An invisible data frame containing starting and ending positions of
each window with its associated gamma
}
\description{
Calculate Gamma values for a window moving through the data.
}
\details{
This is used for data sets that are ordered on one or more dimension, such as
time series or spatial data.  The search slides a window across the data set,
calculating gamma for the data at each step.  A change in causal dynamics will
appear as a spike in gamma when the causal discontinuity is in the window.
}
\examples{
he <- embed(henon_x, 13)
t <- he[ , 1]
p <- he[ ,2:13]
moving_window_search(p, t, by = 5, caption = "my data")
}
