#' Token value class.
#'
#' Represents a SQL value such as a number or a string.
#'
#' @examples
#' # No example since this class is not exported.
#'
#' @import R6
#' @include Token.R
#' @include utils.R
TokenValue <- R6::R6Class("TokenValue",
  inherit = Token,
  public = list(

    #' @description
    #' Initializer.
    #' @param value The value.
    #' @return Nothing.
    initialize = function(value) {
      chk::chk_scalar(value)
      private$value <- value
      return(invisible(NULL))
    },

    #' @description
    #' Converts into a string.
    #' @return A string containing the SQL expression.
    toString = function() {
      return(quote_values(private$value))
    }
  ),
  private = list(
    value = NULL
  )
)
