% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EWMA.R
\docType{class}
\name{SPCEWMA-class}
\alias{SPCEWMA-class}
\title{EWMA Charts}
\description{
Class extending SPCChart with a basic  EWMA charts implementation.
}
\details{
Let \eqn{Y_t, t=1,2,\dots} be the updates from the data model. Then
the EWMA chart is given by \eqn{Q_0=0} and
\deqn{Q_t=lambda Y_t+(1-lambda) Q_{t-1}}
}
\section{Slots}{

\describe{
\item{\code{model}}{The data model. The  data  model should center the in-control
updates such that they have mean 0.}

\item{\code{lambda}}{The smoothing constant, \eqn{0<lambda<=1}.}
}}
\examples{
X <-  rnorm(1000)
chart <- new("SPCEWMA",model=SPCModelNormal(Delta=0),lambda=0.8)
\dontrun{
SPCproperty(data=X,nrep=10,chart=chart,
            property="calARL",params=list(target=100))
SPCproperty(data=X,nrep=10,chart=chart,
            property="calhitprob",params=list(target=0.05,nsteps=1e3))
}
SPCproperty(data=X,nrep=10,chart=chart,
            property="ARL",params=list(threshold=3))
SPCproperty(data=X,nrep=10,chart=chart,
            property="hitprob",params=list(threshold=3,nsteps=1e3))
#increase the number of repetitions nrep for real applications.

}

