# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @name log_a_to_base_b
#'
#' @title Compute the log of a to base b.
#'
#' @description Compute the log of a to base b.
#'
#' @author Phil Davies.
#'
#' @param a Integer to find the log to base b of.
#' @param b Base
#'
#' @return The log of a to base b.
#'
#' @keywords internal
NULL

#' @name mod
#'
#' @title Vector modulus.
#'
#' @description Computes the remainder of dividing a by n using the modulo operator.
#' This function uses a trick to avoid using the modulo operator directly, which can be slow
#' for large values of a and n.
#'
#' @author Phil Davies.
#'
#' @param a The input value of type T. This is a NumericVector.
#' @param n The divisor of type int.
#'
#' @return The remainder of dividing a by n, of type T in the form of a NumericVector.
#'
#' @keywords internal
NULL

#' @name removeDuplicates
#'
#' @title Remove duplicate values from a NumericVector.
#'
#' @description Sort the input numeric vector and removes any duplicate values.
#'
#' @author Phil Davies.
#'
#' @param vec A NumericVector that may contain duplicate values.
#'
#' @return A NumericVector that is sorted with duplicates removed.
#'
#' @keywords internal
NULL

#' @name cppBASpts
#'
#' @title Generate numbers from a Halton Sequence.
#'
#' @description For efficiency, this function can generate points along a random start
#' Halton Sequence for a predefined Halton.
#'
#' @author This function was first written in R by Blair Robertson, subsequently it was
#' re-written in C/C++ by Phil Davies.
#'
#' @param n Number of points required.
#' @param seeds Random starting point in each dimension.
#' @param bases Co-prime base for the Halton Sequence.
#' @param verbose A boolean indicating whether informational messages are to be issued.
#'
#' @return Matrix with the columns, order of points, x in [0,1) and y in [0,1)
#'
#' @examples
#' # First 10 points in the Halton Sequence for base 2,3
#' spbal::cppBASpts(n = 10)
#' # First 10 points in the Halton Sequence for base 2,3 with
#' # starting point at the 15th and 22nd index.
#' spbal::cppBASpts(n = 10, seeds = c(14, 21))
#'
#' @export
cppBASpts <- function(n = 10L, seeds = as.integer( c()), bases = as.numeric( c()), verbose = FALSE) {
    .Call(`_spbal_cppBASpts`, n, seeds, bases, verbose)
}

#' @name cppRSHalton_br
#'
#' @title Generate numbers from a Halton Sequence with a random start
#'
#' @description For efficiency, this function can generate points along a random start
#' Halton Sequence for a predefined Halton.
#'
#' @author This function was first written in R by Blair Robertson, subsequently it was written
#' in C/C++ by Phil Davies.
#'
#' @param n Number of points required
#' @param bases Co-prime base for the Halton Sequence
#' @param seeds Random starting point in each dimension
#' @param verbose A boolean indicating whether informational messages are to be issued.
#'
#' @return Matrix with the columns, order of point, x in [0,1) and y in [0,1).
#'
#' @examples
#' # First 10 points in the Halton Sequence for base 2,3
#'  spbal::cppRSHalton_br(n = 10)
#' # First 10 points in the Halton Sequence for base 2,3 with
#' # starting point at the 15th and 22nd index.
#'  spbal::cppRSHalton_br(n = 10, seeds = c(14, 21))
#'
#' @export
cppRSHalton_br <- function(n = 10L, bases = as.numeric( c()), seeds = as.numeric( c()), verbose = FALSE) {
    .Call(`_spbal_cppRSHalton_br`, n, bases, seeds, verbose)
}

#' @name cppBASptsIndexed
#'
#' @title Generate numbers from a Halton Sequence along a specified set of indices.
#'
#' @description For efficiency, this function can generate points along a random start
#' Halton Sequence for a predefined set of indices away from the seed.
#' When boxes are provided it will calculate the Halton Sequence only
#' at those boxes and not along the entire sequence.
#'
#' @details When not all points along the Halton sequence are required, this function efficiently generates the points
#' that are needed along a sequence. Taking all points from the random seed equates to boxes = 1:n. However, taking
#' advantage of how the Halton Sequence repeats itself by B = prod(base^J), where $J$ is an integer. We can also select
#' every Bth box to efficiently generate values at specific locations along the sequence. This reduces future computation
#' when bounding boxes are large in comparison to the polygon being sampled.
#'
#' @author Phil Davies, Paul van Dam-Bates, Blair Robertson.
#'
#' @param n Number of points required.
#' @param seeds Random starting point in each dimension.
#' @param bases Co-prime base for the Halton Sequence.
#' @param boxes Integer vector of indices to sample along the Halton sequence (default 1:n).
#' @param verbose A boolean indicating whether informational messages are to be issued.
#'
#' @return Matrix with the columns, order of points, x in [0,1) and y in [0,1)
#'
#' @examples
#' # First 10 points in the Halton Sequence for base 2,3
#' spbal::cppBASptsIndexed(n = 10)
#' # First 10 points in the Halton Sequence for base 2,3 with
#' # starting point at the 15th and 22nd index.
#' spbal::cppBASptsIndexed(n = 10, seeds = c(14, 21))
#'
#' @export
cppBASptsIndexed <- function(n = 10L, seeds = as.integer( c()), bases = as.numeric( c()), boxes = as.integer( c()), verbose = FALSE) {
    .Call(`_spbal_cppBASptsIndexed`, n, seeds, bases, boxes, verbose)
}

