% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/threshold_operator.R
\name{thresh_op}
\alias{thresh_op}
\title{This function computes the thresholding sparse covariance estimator for a given threshold level.}
\usage{
thresh_op(z, operator, delta, n)
}
\arguments{
\item{z}{The sample covariance matrix.}

\item{operator}{The choice of the thresholding operator.}

\item{delta}{The thresholding level.}

\item{n}{The sample size of data matrix.}
}
\value{
The thresholding sparse covariance estimator for a given threshold level.
}
\description{
This function computes the thresholding sparse covariance estimator for a given threshold level.
}
\examples{
## generate data from a block diagonal covariance matrix structure
n <- 50
p <- 30
data.true.cov <- block.true.cov(p)
data <- sampleMVN(n, data.true.cov, sparse=TRUE)
## compute the sample covariance
z <- Rfast::cova(data) *(n-1)/n
## get the sparse covariance matrix estimator for a given threshold level
s <- thresh_op(z, operator='soft', delta=1, n=n)
s[1:9,1:9]
}
