% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mitscherlich.R
\name{mitscherlich}
\alias{mitscherlich}
\alias{mits_formula_1}
\alias{mits_formula_2}
\alias{mits_formula_3}
\alias{boot_mitscherlich}
\title{Mitscherlich response function}
\usage{
mits_formula_1(x, a, b, c)

mits_formula_2(x, b, c)

mits_formula_3(x, c)

mitscherlich(
  data = NULL,
  stv,
  ry,
  type = 1,
  target = 95,
  tidy = TRUE,
  plot = FALSE,
  resid = FALSE
)

boot_mitscherlich(data, stv, ry, type = 1, n = 999, target = 95, ...)
}
\arguments{
\item{x}{selfstart vector. for model fit Default: NULL}

\item{a}{selfstart arg. for asymptote parameter, Default: NULL}

\item{b}{selfstart arg. for b parameter (b = -X_intercept) Default: NULL}

\item{c}{selfstart arg. for curvature parameter Default: NULL}

\item{data}{Optional argument to call and object of type data.frame or data.table
containing the stv and ry data, Default: NULL}

\item{stv}{name of the vector containing soil test values (-) of type \code{numeric}.}

\item{ry}{name of the vector containing relative yield values (\%) of type \code{numeric}.}

\item{type}{string or number that indicates the type of Mitscherlich model to fit. Default: 1.
For model with 'no restrictions' use \code{type = 1}, \code{type = "no restriction"}, or \code{type = "free"};
For model with 'asymptote = 100' use \code{type = 2}, \code{type = "asymptote 100"}, or \code{type = "100"};
For model with 'asymptote = 100 and xintercept = 0'" \code{type = 3}, \code{type = "asymptote 100 from 0"}, or \code{type = "fixed"}.}

\item{target}{\code{numeric} value of relative yield target (e.g. 90 for 90\%) to estimate the CSTV.
Default: NULL}

\item{tidy}{logical operator (TRUE/FALSE) to decide the type of return. TRUE returns a tidy data frame or tibble (default), FALSE returns a list.}

\item{plot}{logical operator (TRUE/FALSE) to plot the Mitscherlich model, Default: FALSE}

\item{resid}{logical operator (TRUE/FALSE) to plot residuals analysis, Default: FALSE}

\item{n}{sample size for the bootstrapping Default: 500}

\item{...}{when running bootstrapped samples, the \code{...} (open arguments) allows to add grouping variable/s (factor or character) Default: NULL}
}
\value{
returns an object of type \code{ggplot} if plot = TRUE.

returns a residuals plot if resid = TRUE.

returns an object of class \code{data.frame} if tidy = TRUE,

returns an object of class \code{list} if tidy = FALSE.

Mitscherlich type 1 formula

Mitscherlich type 2 formula

Mitscherlich type 3 formula

mitscherlich: function

boot_mitscherlich: bootstrapping function
}
\description{
This function helps to fit a Mitscherlich-style exponential
response model for relative yield (ry) as a function of soil test values (stv).
}
\details{
See \href{https://adriancorrendo.github.io/soiltestcorr/articles/mitscherlich_tutorial.html}{online-documentation} for additional details.
}
\note{
For extended reference, we recommend to visit:
\url{https://github.com/austinwpearce/SoilTestCocaCola} by Austin Pearce.
}
\examples{
\donttest{
 # Example dataset
 dat <- data.frame("ry" = c(65,80,85,88,90,94,93,96,97,95,98,100,99,99,100),
                   "stv" = c(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15))
 # Run
 fit_example_mits <- mitscherlich(data = dat, type = 1, 
 ry = ry, stv = stv, resid = TRUE, plot = FALSE)
 
 fit_example_mits
}
}
\references{
Melsted, S.W. and Peck, T.R. (1977).
The Mitscherlich-Bray Growth Function.
\emph{In Soil Testing (eds T. Peck, J. Cope and D. Whitney).} \doi{10.2134/asaspecpub29.c1}
}
\seealso{
\code{\link[rlang]{eval_tidy}},\code{\link[rlang]{defusing-advanced}}
\code{\link[minpack.lm]{nlsLM}}
\code{\link[stats]{AIC}},\code{\link[stats]{lm}},\code{\link[stats]{optim}},\code{\link[stats]{coef}},\code{\link[stats]{predict}}
\code{\link[AICcmodavg]{AICc}}
\code{\link[modelr]{model-quality}}
\code{\link[nlstools]{nlsResiduals}}
\code{\link[dplyr]{bind}}
\code{\link[ggplot2]{ggplot}},\code{\link[ggplot2]{aes}},\code{\link[ggplot2]{geom_rug}},\code{\link[ggplot2]{geom_point}},\code{\link[ggplot2]{geom_abline}},\code{\link[ggplot2]{geom_path}},\code{\link[ggplot2]{annotate}},\code{\link[ggplot2]{labs}},\code{\link[ggplot2]{theme}}
}
