% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_stations.R
\name{list_snirh_parameters}
\alias{list_snirh_parameters}
\title{List available SNIRH parameters}
\usage{
list_snirh_parameters(sample_type = "all", include_conversion_info = FALSE)
}
\arguments{
\item{sample_type}{Character string specifying the sample type to filter by.
Must be one of "water", "biota", "sediment", or "all". Default is "all".}

\item{include_conversion_info}{Logical. If TRUE, includes conversion factors
and unit information. Default is FALSE.}
}
\value{
A data.table with parameter information. Columns depend on
include_conversion_info parameter.
}
\description{
Returns a summary of available parameters in the conversion table,
organized by sample type. This helps users understand what parameters
can be converted to SNIRH format.
}
\details{
This function provides an overview of the parameter conversion capabilities
of the package. It can help users:
\itemize{
\item Understand what parameters are supported
\item Check parameter naming conventions
\item Verify unit conversion factors
\item Plan data preparation activities
}
}
\examples{
\donttest{
# List all water parameters
water_params <- list_snirh_parameters("water")
print(head(water_params))

# Get detailed conversion information
detailed_params <- list_snirh_parameters("water", include_conversion_info = TRUE)
print(head(detailed_params))

# Check all available sample types
all_params <- list_snirh_parameters("all")
unique_types <- unique(all_params$sample_type)
print(paste("Available sample types:", paste(unique_types, collapse = ", ")))
}

}
\seealso{
\code{\link{parameters}} for the complete parameter dataset
}
