##' @name mental.impairment
##'
##' @title Mental Impairment Data
##'
##' @docType data
##'
##' @description Data from a study in Alachua County, Florida on
##' between mental health. Source A. Charles Holzer.  See Table 11.1
##' of the 4th edition.
##'
##' @format \Sexpr[stage=build,results=rd]{data(mental.impairment); smss:::describe_df(mental.impairment)}
##' \describe{
##' \item{\code{impair}}{Mental impairment}
##' \item{\code{life}}{Life events score}
##' \item{\code{ses}}{Social economic status}
##' }
##'
##' @examples
##' data(mental.impairment)
##' summary(mental.impairment)
##' @source \url{http://www.stat.ufl.edu/~aa/social/data.html}
NULL

