% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sm_slope_mean.R
\name{sm_slope_mean}
\alias{sm_slope_mean}
\title{Slope Chart with Mean for a Single Group}
\usage{
sm_slope_mean(
  ...,
  labels,
  group,
  main_color = sm_color("blue"),
  main_shape = 21,
  back_alpha = 0.25,
  line_width = 0.25,
  avgline_width = 1,
  point_size = 2.5,
  avgpoint_size = 4,
  err_width = 1,
  xTick.params = list(position = "top", expand = c(0.17, 0.1), drop = FALSE),
  errorbar_type = "sd",
  show_err = FALSE,
  legends = FALSE
)
}
\arguments{
\item{...}{Additional aesthetic parameters applied across points, lines, and error bars. Optional.}

\item{labels}{A vector specifying the labels for the x-axis ticks. This is a required argument.
For example: \code{c('Day 1', 'Day 2')}.}

\item{group}{The name of the variable used to group individual data points. This is a required argument.}

\item{main_color}{The main color of the slope chart, shared across:
\itemize{
  \item Points
  \item Lines
  \item Error bars
}
Default: \code{sm_color('blue')}.}

\item{main_shape}{The shape of the points in the slope chart:
\itemize{
  \item Shapes above \code{20} use \code{color = 'white'} and a fill color matching \code{main_color}.
}
Default: \code{21}.}

\item{back_alpha}{Transparency (alpha) for the shadow lines and points:
\itemize{
  \item Lines: controlled by \code{back_alpha}.
  \item Points: controlled by \code{back_alpha * 0.65}.
}
Default: \code{0.25}.}

\item{line_width}{Line width for the shadow lines connecting points. Default: \code{0.25}.}

\item{avgline_width}{Line width for the average line. Default: \code{1}.}

\item{point_size}{Size of the points in the shadow. Default: \code{2.5}.}

\item{avgpoint_size}{Size of the points representing the mean of the data. Default: \code{4}.}

\item{err_width}{Line width for the error bars. Default: \code{1}.}

\item{xTick.params}{A list of parameters for customizing the x-axis ticks. Options include:
\itemize{
  \item \code{position}: Location of the ticks (default: \code{'top'}).
  \item \code{expand}: Space around the ticks (default: \code{c(0.17, 0.1)}).
  \item \code{drop}: Whether to drop unused factor levels (default: \code{FALSE}).
}}

\item{errorbar_type}{A string specifying the type of error bars to display:
\itemize{
  \item \code{'se'}: Standard error.
  \item \code{'sd'}: Standard deviation (default).
  \item \code{'ci'}: 95% confidence interval.
}}

\item{show_err}{Logical. Determines whether to display error bars:
\itemize{
  \item \code{TRUE}: Display error bars.
  \item \code{FALSE}: Hide error bars (default).
}}

\item{legends}{Logical. Determines whether to display legends:
\itemize{
  \item \code{TRUE}: Display legends.
  \item \code{FALSE}: Hide legends (default).
}}
}
\value{
A slope chart with mean, represented as a ggplot2 object.
}
\description{
Generates a slope chart with mean for a single group. This is useful for comparing
the effect between two time points. The function includes options for shadow lines
and points, mean lines, points, and error bars, all of which can be customized.

Note: This functionality can also be reproduced using `sm_slope()` with appropriate
customization. In `ggplot()`, the mapping requires grouping each observation to
correctly pair points.
}
\examples{
library(ggplot2)
library(smplot2)

set.seed(1) # generate random data
day1 <- rnorm(16, 2, 1)
day2 <- rnorm(16, 5, 1)
Subject <- rep(paste0("S", seq(1:16)), 2)
Data <- data.frame(Value = matrix(c(day1, day2), ncol = 1))
Day <- rep(c("Day 1", "Day 2"), each = length(day1))
df <- cbind(Subject, Data, Day)

ggplot(data = df, aes(x = Day, y = Value)) +
  sm_slope_mean(
    labels = c("Day 1", "Day 2"), group = Subject, back_alpha = .3,
    main_color = sm_color("green")
  )
}
