% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sm_plot_clean.R
\name{sm_plot_clean}
\alias{sm_plot_clean}
\title{Remove xticklabels and yticklabels in selected panels for proper subplotting}
\usage{
sm_plot_clean(all_plots, ncol, nrow, wmargin = wmargin, hmargin = hmargin)
}
\arguments{
\item{all_plots}{all_plots should be list, which should contain all panels
that are to be combined into one figure.}

\item{ncol}{Number of columns in the combined plot}

\item{nrow}{Number of rows in the combined plot}

\item{wmargin}{The amount of width of blank space between subplots.  It sets the size of the empty space (i.e., margin) between panels. T
he default is set to 1, which should reduce the empty space (right and left side of each panel)
between the panels.}

\item{hmargin}{The amount of height of blank space between subplots. It sets the size of the empty space (i.e., margin) between panels. T
he default is set to 1, which should reduce the empty space (right and left side of each panel)
between the panels.}
}
\value{
Returns a list of plots with new layouts.
}
\description{
Remove xticklabels and yticklabels in selected panels for proper subplotting
}
\examples{
library(smplot2)
library(ggplot2)
ggplot(data = mtcars, mapping = aes(x = drat, y = mpg)) +
  geom_point(
    shape = 21, fill = "#0f993d", color = "white",
    size = 3
  ) -> p1

ggplot(data = mtcars, mapping = aes(x = drat, y = mpg)) +
  geom_point(shape = 21, fill = "#0f993d", color = "white", size = 3) +
  sm_hvgrid() -> p2

sm_plot_clean(list(p1, p2), ncol = 2, nrow = 1, wmargin = -2, hmargin = -2)

}
