\name{SMOTEfamily}
\alias{SMOTEfamily}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
	SMOTE family package for Data Generation
}

\description{
	The collection of SMOTE algorithm and some of its variants for oversampling numeric data 
}
\details{
	This package is built to collect several oversampling techniques for Imbalanced data which are parts of my doctorate research. Data to be used with these techniques in this package must be all numeric with one nominal attribute worked as the target class. 
}
\author{
	Wacharasak Siriseriwan <wacharasak.s@gmail.com>
}
\seealso{ 
	\code{\link{SMOTE}}
	\code{\link{SLS}}
	\code{\link{DBSMOTE}}
	\code{\link{RSLS}}
	\code{\link{ANS}}
	\code{\link{BLSMOTE}}
}

\references{
	'Chawla, N., Bowyer, K., Hall, L. and Kegelmeyer, W. 2002. SMOTE: Synthetic minority oversampling technique. Journal of Artificial Intelligence Research. 16, 321-357.'
	'Bunkhumpornpat, C., Sinapiromsaran, K. and Lursinsap, C. 2009. Safe-level-SMOTE: Safe-level-synthetic minority oversampling technique for handling the class imbalanced problem. Proceedings of the 13th Pacific-Asia Conference on Advances in Knowledge Discovery and Data Mining. 2009, 475-482.'
	'Bunkhumpornpat, C., Sinapiromsaran, K. and Lursinsap, C. 2012. DBSMOTE: Density-based synthetic minority oversampling technique. Applied Intelligence. 36, 664-684.'
	'Siriseriwan, W. and Sinapiromsaran, K. The Effective Redistribution for Imbalance Dataset : Relocating Safe-Level SMOTE with Minority Outcast Handling. Chiang Mai Journal of Science. 43(1), 234 - 246.'
	'Siriseriwan, W. and Sinapiromsaran, K. Adaptive neighbor Synthetic Minority Oversampling TEchnique under 1NN outcast handling.Songklanakarin Journal of Science and Technology.'
	'Han, H., Wang, W.Y. and Mao, B.H.  Borderline-SMOTE: a new over-sampling method in imbalanced data sets learning. In Proceedings of the 2005 international conference on Advances in Intelligent Computing - Volume Part I (ICIC'05), De-Shuang Huang, Xiao-Ping Zhang, and Guang-Bin Huang (Eds.), Vol. Part I. Springer-Verlag, Berlin, Heidelberg, 2005. 878-887.  DOI=http://dx.doi.org/10.1007/11538059_91'
}
\examples{
	\dontrun{
    	data_example = sample_generator(10000,ratio = 0.80)
	genData = SMOTE(data_example[,-3],data_example[,3])
	genData_2 = SMOTE(data_example[,-3],data_example[,3],K=7)
	}
}