% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{phosphorus}
\alias{phosphorus}
\title{Olsen Phosphorus}
\format{
A data frame with 3 variables: \code{DPlot}, \code{OlsenP}, \code{Yield}.
\describe{
  \item{DPlot}{Factor. Unique identifier for each field plot.}
  \item{OlsenP}{Numeric. Available soil phosphorus content measured as Olsen P (mg/kg or ppm).}
  \item{Yield}{Numeric. Yield of spring barley from each plot (typically in tonnes per hectare, t/ha).}
}
}
\source{
Welham, S. J., Gezan, S. A., Clark, S. J., and Mead, A. (2015) \emph{Statistical Methods in Biology: Design and analysis of experiments and regression}
}
\usage{
phosphorus
}
\description{
The data originate from the long-term Exhaustion Land field trial at Rothamsted Research, which examines the relationship between crop yield and soil fertilizer inputs. In 1986, the yields of spring barley (variate Yield) were recorded from 20 plots. For each plot, the available soil phosphorus content was also measured using the Olsen P method (variate OlsenP). This dataset allows for the analysis of how variations in soil phosphorus levels influence barley yield under field conditions.
}
\examples{
lm(Yield ~ log10(OlsenP), data = phosphorus)

}
\keyword{datasets}
