% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{brassica}
\alias{brassica}
\title{Sreening for pathogenicity}
\format{
A data frame with 9 variables: \code{ID}, \code{Rep}, \code{Tray}, \code{Species}, \code{Isolate}, \code{TypeA}, \code{TypeB}, \code{Seedlings}, \code{Resistant}.
\describe{
  \item{ID}{Factor. Unique identifier for each observation (row) in the dataset.}
  \item{Rep}{Factor. Replicate/run number in the experiment (1–3), representing separate experimental runs across time.}
  \item{Tray}{Factor. Tray identifier for the batch of seedlings tested in each replicate (13 levels).}
  \item{Species}{Factor. Brassica species from which the fungal isolate was collected ("A" or "B").}
  \item{Isolate}{Factor. Identifier for the fungal isolate tested (nine levels across groups; unique within each Species).}
  \item{TypeA}{Integer. Isolate identifier re-coded for group A isolates (repeats the "Isolate" value for group A, NA or other coding for group B).}
  \item{TypeB}{Integer. Isolate identifier re-coded for group B isolates (repeats the "Isolate" value for group B, NA or other coding for group A).}
  \item{Seedlings}{Integer. Number of seedlings tested per tray (22 or 23).}
  \item{Resistant}{Integer. Number of seedlings in the tray showing no signs of infection (i.e., counted as resistant) five days after inoculation.}
}
}
\source{
Welham, S. J., Gezan, S. A., Clark, S. J., and Mead, A. (2015) \emph{Statistical Methods in Biology: Design and analysis of experiments and regression}
}
\usage{
brassica
}
\description{
An experiment was conducted to assess the pathogenicity of various fungal isolates on oilseed rape seedlings. Fungal isolates were obtained from two Brassica species, labeled as A and B (Species), and included nine isolates from group A and four from group B (Isolate). The experimental design involved three replicate runs across time (Rep), with each replicate using trays of seedlings—either 22 or 23 seedlings per tray (Tray, with 13 levels; variate: Seedlings)—exposed toeach isolate. Five days after inoculation, the number of resistant seedlings showing no signs of infection (Resistant) was recorded for each tray, and the percentage of resistant seedlings was used as the response variable for analysis. This design allows for evaluation of differences in pathogenicity among isolates, considering variability due to species, replicates, and tray sizes.
}
\examples{
fit <- aov(log(P / (100 - P)) ~ Species / Isolate + Error(Rep / Tray),
           data = brassica |>
             transform(P = 100 * (Resistant + 1) / (Seedlings + 2)))
summary(fit)

}
\keyword{datasets}
