% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01-sample_size.R
\name{get_n_clusters}
\alias{get_n_clusters}
\title{Calculate number of clusters to sample to reach target sample size}
\usage{
get_n_clusters(n, n_cluster, u5, p)
}
\arguments{
\item{n}{Target sample size of cases for the coverage survey.}

\item{n_cluster}{Average cluster population for all ages in the specified
survey area.}

\item{u5}{Proportion (value from 0 to 1) of population that are aged 6-59
months.}

\item{p}{Prevalence (value from 0 to 1) of condition that is to be assessed.}
}
\value{
A numeric value of the estimated number of clusters to sample to
reach target sample size.
}
\description{
Calculate number of clusters to sample to reach target sample size
}
\examples{
## Calculate number of villages to sample given an average village population
## of 600 persons of all ages with an under-5 population of 17\% and a
## prevalence of SAM of 2\% if the target sample size is 40
get_n_clusters(n = 40, n_cluster = 600, u5 = 0.17, p = 0.02)

}
