% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sklarsomega.R
\name{summary.sklarsomega}
\alias{summary.sklarsomega}
\title{Print a summary of a Sklar's Omega fit.}
\usage{
\method{summary}{sklarsomega}(object, alpha = 0.05, digits = 4, ...)
}
\arguments{
\item{object}{an object of class \code{sklarsomega}, the result of a call to \code{\link{sklars.omega}}.}

\item{alpha}{the significance level for the confidence intervals. The default is 0.05.}

\item{digits}{the number of significant digits to display. The default is 4.}

\item{\dots}{additional arguments.}
}
\description{
Print a summary of a Sklar's Omega fit.
}
\details{
Unless optimization of the objective function failed, this function prints a summary of the fit. First, the value of the objective function at its maximum is displayed, along with the number of iterations required to find the maximum. Then the values of the control parameters (defaults and/or values supplied in the call) are printed. Then a table of estimates is shown. If applicable, the table includes confidence intervals. Finally, the values of \code{\link{AIC}} and BIC are displayed (if the scores are continuous and inference is parametric).
}
\examples{
# Fit a subset of the cartilage data, assuming a Laplace marginal distribution. Compute
# confidence intervals in the usual ML way (observed information matrix). Note that
# using confint = bootstrap leads to bootstrap sampling and bootstrap intervals.

data(cartilage)
data.cart = as.matrix(cartilage)[1:100, ]
colnames(data.cart) = c("c.1.1", "c.2.1")
fit.lap = sklars.omega(data.cart, level = "balance", confint = "asymptotic",
                       control = list(dist = "laplace"))
summary(fit.lap)
}
\references{
Nissi, M. J., Mortazavi, S., Hughes, J., Morgan, P., and Ellermann, J. (2015). T2* relaxation time of acetabular and femoral cartilage with and without intra-articular Gd-DTPA2 in patients with femoroacetabular impingement. \emph{American Journal of Roentgenology}, \bold{204}(6), W695.
}
\seealso{
\code{\link{sklars.omega}}
}
