% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posteriors.R
\name{postTaui}
\alias{postTaui}
\title{Sample a value from the full conditional posterior of tau_i}
\usage{
postTaui(yij, cij, mui, thetai, phi = 1)
}
\arguments{
\item{yij}{Numeric vector, cycle lengths for a single individual}

\item{cij}{Positive Integer vector, a sampled vector of length(yij) where the corresponding
values in cij indicate a sampled number of TRUE cycles in each cycle length given by yij}

\item{mui}{Numeric, log of sampled mean of this individual's yijs}

\item{thetai}{Numeric, mean of prior (gamma) distribution on taui}

\item{phi}{Numeric, rate for Taui prior}
}
\value{
Numeric vector, repeated sampled value of length(yij)
}
\description{
In our model the data are drawn from LogN(mu_i + log(c_ij), tau_i). The prior for tau_i
is given as Gamma(thetai*phi, phi). This function draws from the conditional
posterior of tau_i. Note that we parameterize with RATE, not SCALE.
}
\details{
Additionally, note that in order to vectorize the remainder of the MCMC algorithm
this function returns the sampled value repeated for length(yij)
}
