% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/liInference.R
\name{likVec}
\alias{likVec}
\title{Monte Carlo estimate of negative marginal log-likelihood of Li model}
\usage{
likVec(
  pars = c(kappa = 180, gamma = 6, alpha = 2, beta = 20),
  S = 10,
  M = 1000,
  cycleDat,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{pars}{Named numeric vector of hyperparameters containing the
elements: kappa, gamma, alpha, beta. NOTE: MUST BE IN CORRECT ORDER.
\itemize{
\item \code{kappa}: Numeric value, shape parameter of Gamma distribution for Lambda_i.
\item \code{gamma}: Numeric value, rate parameter of Gamma distribution for Lambda_i.
\item \code{alpha}: Numeric value, shape1 parameter of Beta distribution for Pi_i.
\item \code{beta}:  Numeric value, shape2 parameter of Beta distribution for Pi_i.
}}

\item{S}{Integer, maximum number of allowed skips in the model.}

\item{M}{Integer specifying the number of Monte Carlo iterations.}

\item{cycleDat}{Data frame containing information about individuals and their tracked cycles.}

\item{verbose}{Logical with default FALSE. If true, prints extra info while running.}

\item{...}{Does nothing.}
}
\value{
Numeric value representing the Monte Carlo estimate of the negative marginal log-likelihood.
}
\description{
This function calculates a Monte Carlo estimate of the negative marginal log-likelihood
of the given hyperparameters for the generative model from Li et al. (2022).
It samples M instances of the parameters from the given distributions
and averages the the likelihoods, giving a marginal likelihood for the hyperparameters.
}
\references{
Li, Kathy, et al. "A predictive model for next cycle start date that accounts for adherence in menstrual self-tracking." Journal of the American Medical Informatics Association 29.1 (2022): 3-11.
}
