% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bickel.R
\name{bickel}
\alias{bickel}
\title{Bickel's Test for Heteroskedasticity in a Linear Regression Model}
\usage{
bickel(
  mainlm,
  fitmethod = c("lm", "rlm"),
  a = "identity",
  b = c("hubersq", "tanhsq"),
  scale_invariant = TRUE,
  k = 1.345,
  statonly = FALSE,
  ...
)
}
\arguments{
\item{mainlm}{Either an object of \code{\link[base]{class}} \code{"lm"}
(e.g., generated by \code{\link[stats]{lm}}), or
a list of two objects: a response vector and a design matrix. The objects
are assumed to be in that order, unless they are given the names
\code{"X"}  and \code{"y"} to distinguish them. The design matrix passed
in a list must begin with a column of ones if an intercept is to be
included in the linear model. The design matrix passed in a list should
not contain factors, as all columns are treated 'as is'. For tests that
use ordinary least squares residuals, one can also pass a vector of
residuals in the list, which should either be the third object or be
named \code{"e"}.}

\item{fitmethod}{A character indicating the method to be used to fit the
regression model. This can be "OLS" for ordinary least squares (the
default) or "robust" in which case a robust fitting method is called
from \code{\link[MASS]{rlm}}.}

\item{a}{A character argument specifying the name of a function to be
applied to the fitted values, or an integer \eqn{m} in which case the
function applied is \eqn{f(x) = x^m}. Defaults to \code{"identity"} for
\code{\link[base]{identity}}.}

\item{b}{A character argument specifying a function to be applied to the
residuals. Defaults to Huber's function squared, as recommended by
\insertCite{Carroll81;textual}{skedastic}. Currently the only supported
functions are \code{"hubersq"} (for Huber's function squared) and
\code{"tanhsq"} (for \eqn{b(x)=\mathrm{tanh}(x)^2}.)}

\item{scale_invariant}{A logical indicating whether the scale-invariance
modification proposed by \insertCite{Carroll81;textual}{skedastic}
should be implemented. Defaults to \code{TRUE}.}

\item{k}{A double argument specifying a parameter for Huber's function
squared; used only if \code{b == "hubersq"}. This is not to be confused
with the argument \code{k2} that could be passed to
\code{\link[MASS]{rlm}} if the regression is fitted using robust methods.
\code{k} defaults to 1.345.}

\item{statonly}{A logical. If \code{TRUE}, only the test statistic value
is returned, instead of an object of \code{\link[base]{class}}
\code{"htest"}. Defaults to \code{FALSE}.}

\item{...}{Optional arguments to be passed to \code{\link[MASS]{rlm}}}
}
\value{
An object of \code{\link[base]{class}} \code{"htest"}. If object is
   not assigned, its attributes are displayed in the console as a
   \code{\link[tibble]{tibble}} using \code{\link[broom]{tidy}}.
}
\description{
This function implements the method of
   \insertCite{Bickel78;textual}{skedastic} for testing for
   heteroskedasticity in a linear regression model, with or without the
   scale-invariance modification of
   \insertCite{Carroll81;textual}{skedastic}.
}
\details{
Bickel's Test is a robust extension of Anscombe's Test
   \insertCite{Anscombe61}{skedastic} in which the OLS residuals and
   estimated standard error are replaced with an \eqn{M} estimator. Under
   the null hypothesis of homoskedasticity, the distribution of the test
   statistic is asymptotically standard normally distributed. The test is
   two-tailed.
}
\examples{
mtcars_lm <- lm(mpg ~ wt + qsec + am, data = mtcars)
bickel(mtcars_lm)
bickel(mtcars_lm, fitmethod = "rlm")
bickel(mtcars_lm, scale_invariant = FALSE)

}
\references{
{\insertAllCited{}}
}
\seealso{
discussions of this test in
  \insertCite{Carroll81;textual}{skedastic} and
  \insertCite{Ali84;textual}{skedastic}.
}
