% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_plot.R
\name{plot.dem_cube}
\alias{plot.dem_cube}
\title{Plot DEM cubes}
\usage{
\method{plot}{dem_cube}(
  x,
  ...,
  band = "ELEVATION",
  tile = x[["tile"]][[1L]],
  roi = NULL,
  palette = "Spectral",
  rev = TRUE,
  scale = 1,
  max_cog_size = 1024L,
  legend_position = "inside"
)
}
\arguments{
\item{x}{Object of class "dem_cube".}

\item{...}{Further specifications for \link{plot}.}

\item{band}{Band for plotting grey images.}

\item{tile}{Tile to be plotted.}

\item{roi}{Spatial extent to plot in WGS 84 - (see notes)}

\item{palette}{An RColorBrewer or "cols4all" palette}

\item{rev}{Reverse the color order in the palette?}

\item{scale}{Scale to plot map (0.4 to 1.0)}

\item{max_cog_size}{Maximum size of COG overviews (lines or columns)}

\item{legend_position}{Where to place the legend (default = "inside")}
}
\value{
A plot object with a DEM cube
                      or a B/W image on a color scale
}
\description{
Plot RGB raster cube
}
\note{
To see which color palettes are supported, please run cols4all::c4a_gui().
Use \code{scale} parameter for general output control.
The following optional parameters are available to allow for detailed
      control over the plot output:
\itemize{
\item \code{graticules_labels_size}: size of coord labels (default = 0.7)
\item \code{legend_title_size}: relative size of legend title (default = 0.7)
\item \code{legend_text_size}: relative size of legend text (default = 0.7)
\item \code{legend_bg_color}: color of legend background (default = "white")
\item \code{legend_bg_alpha}: legend opacity (default = 0.3)
}
To define a \code{roi} use one of:
     \itemize{
       \item{A path to a shapefile with polygons;}
       \item{A \code{sfc} or \code{sf} object from \code{sf} package;}
       \item{A \code{SpatExtent} object from \code{terra} package;}
       \item{A named \code{vector} (\code{"lon_min"},
            \code{"lat_min"}, \code{"lon_max"}, \code{"lat_max"}) in WGS84;}
       \item{A named \code{vector} (\code{"xmin"}, \code{"xmax"},
             \code{"ymin"}, \code{"ymax"}) with XY coordinates.}
}
}
\examples{
if (sits_run_examples()) {
    # obtain the DEM cube
    dem_cube_19HBA <- sits_cube(
        source = "MPC",
        collection = "COP-DEM-GLO-30",
        bands = "ELEVATION",
        tiles = "19HBA"
    )
    # plot the DEM reversing the palette
    plot(dem_cube_19HBA, band = "ELEVATION")
}
}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}
}
