% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storeCache.R
\name{storeCache}
\alias{storeCache}
\title{Stores as a cache an already-produced R object}
\usage{
storeCache(
  cacheName,
  cacheDir = getCacheDir(),
  cacheSubDir = NULL,
  recreate = FALSE
)
}
\arguments{
\item{cacheName}{Unique name for the cache (and R object to be cached).}

\item{cacheDir}{The directory where caches are saved (and loaded from).
Defaults to the global \code{\link[=setCacheDir]{RCACHE.DIR}} variable}

\item{cacheSubDir}{You can specify a subdirectory within the cacheDir
variable. Defaults to \code{NULL}.}

\item{recreate}{Forces reconstruction of the cache}
}
\description{
Sometimes you use significant computational power to create an object, but
you didn't cache it with \code{\link{simpleCache}}. Oops, maybe you wish you had, after the
fact. This function lets you store an object in the environment so it could
be loaded by future calls to \code{simpleCache}.
}
\details{
This can be used in interactive sessions, but could also be used for another
use case: you have a complicated set of instructions (too much to pass as the
instruction argument to \code{simpleCache}), so you could just stick a call to
\code{storeCache} at the end.
}
\examples{
# choose location to store caches
cacheDir = tempdir()
cacheDir
setCacheDir(cacheDir)

# build some caches
simpleCache("normSample", { rnorm(5e3, 0,1) }, recreate=TRUE, timer=TRUE)
simpleCache("normSample", { rnorm(5e3, 0,1) })
simpleCache("normSample", { rnorm(5e3, 0,1) }, reload=TRUE)

# storing a cache after-the-fact
normSample2 = rnorm(10, 0, 1)
storeCache("normSample2")

# what's available?
listCaches()

# load a cache
simpleCache("normSample")

# load multiples caches
loadCaches(c("normSample", "normSample2"), reload=TRUE)
}
