% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/global_stutter_model.R
\name{global_stutter_model}
\alias{global_stutter_model}
\title{Global stutter model where the expected stutter rate is constant across alleles and loci}
\usage{
global_stutter_model(
  back_stutter_rate,
  forward_stutter_rate,
  size_regression,
  sex_locus_name = "AMEL"
)
}
\arguments{
\item{back_stutter_rate}{Numeric. (Optional)}

\item{forward_stutter_rate}{Numeric. (Optional)}

\item{size_regression}{Function, see \link{read_size_regression}.}

\item{sex_locus_name}{Character vector, defaults to "AMEL".}
}
\value{
Object of class \code{stutter_model} to be used by e.g. \link{gamma_model}.
}
\description{
Global stutter model where the expected stutter rate is constant across alleles and loci
}
\details{
When a pg_model is constructed (see \link{gamma_model}), a stutter model can optionally be applied. In the global stutter model, the expected stutter rate is constant across all loci and for all parent alleles.
}
\examples{
# the stutter model needs a size regression to determine fragment length
# of stutter products
size_regression <- read_size_regression(system.file("extdata",
"GlobalFiler_SizeRegression.csv",package = "simDNAmixtures"))

# define a stutter model with an expected back stutter rate of 10\%
stutter_model <- global_stutter_model(back_stutter_rate = 0.1,
                                     size_regression = size_regression)

stutter_model
}
\seealso{
\link{allele_specific_stutter_model} for a stutter model where the expected stutter rate depends on the allele and locus.
}
