% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/source_han.R
\name{source_han}
\alias{source_han}
\alias{source_han_sans}
\alias{source_han_serif}
\title{Meta-information for the Source Han Sans/Serif Fonts}
\usage{
source_han_sans(lang = c("CN", "TW", "JP", "KR"))

source_han_serif(lang = c("CN", "TW", "JP", "KR"))
}
\arguments{
\item{lang}{Language of the font. "CN" for simplified Chinese, "TW" for
traditional Chinese, "JP" for Japanese, and "KR" for Korean.}
}
\description{
These functions provide information of the Source Han Sans/Serif fonts
that can be used in the \code{\link{font_install}()} function.
Source Han Sans/Serif fonts provide complete support for the
CJK (\strong{C}hinese, \strong{J}apanese, and \strong{K}orean) characters.
}
\examples{
\dontrun{
## Install Source Han Sans font (by default Simplified Chinese)
## to the showtexdb package
font_install(source_han_sans())

## Source Han Serif Japanese
font_install(source_han_serif("JP"))
}
}
\author{
Yixuan Qiu <\url{https://statr.me/}>
}
