% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/irt_estimate.R
\name{irt_estimate}
\alias{irt_estimate}
\title{Estimate of theta}
\usage{
irt_estimate(item_par, responses = NULL, theta, lower = -3, upper = abs(lower))
}
\arguments{
\item{item_par}{\code{data.frame}, dataframe with nrows equal to the number of items and 4 columns, one for each of the item parameters. The columns must be named "a", "b", "c", "e" and must contain the respective IRT parameters, namely discrimination \eqn{a_i}, location \eqn{b_i}, pseudo-guessing \eqn{c_i}, and upper asymptote \eqn{e_i}.}

\item{responses}{\code{matrix}, \eqn{p \times i} matrix with the dichotomous responses of each respondent \eqn{p} on each item \eqn{i}. Default is \code{NULL}.}

\item{theta}{\code{numeric} latent trait level of person \eqn{p}, it can be a single value or a vector of values.}

\item{lower}{\code{integer} lower value of \eqn{\theta} to be considered for the estimation}

\item{upper}{\code{integer} upper value of \eqn{\theta} to be considered for the estimation}
}
\value{
A numeric vector of length equal to the length of \code{theta} with the ML estimation of the latent trait
}
\description{
Maximum Likelihood estimation of theta
}
\examples{
set.seed(123)
n <- 50
theta <- rnorm(500)
item_par <- data.frame(
  b = runif(n, -3, 3),
  a = runif(n, 1.2, 1.9),
  c = rep(0, n),
  e = rep(1, n)
)
# estimate theta
theta_hat <- irt_estimate(item_par, theta = theta)
plot(theta, theta_hat)
}
