% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{use_shiny_title}
\alias{use_shiny_title}
\title{Enable \code{shinytitle}}
\usage{
use_shiny_title()
}
\value{
A script tag that enables \code{shinytitle} to work within a shiny app.
}
\description{
Add this function to the UI of a shiny application in order for you to be able to update the
browser title.
}
\examples{
if (interactive()) {
  library(shiny)

  ui <- fluidPage(
    title = "Initial Title",
    use_shiny_title(),
    actionButton("button", "Click me for a new title"),
  )

  server <- function(input, output, session) {
    observeEvent(input$button, {
      change_window_title(session, "New Title")
    })
  }

  shinyApp(ui, server)
}

}
\seealso{
\code{\link{change_window_title}} \code{\link{flashing_window_title}}
}
