 \name{EAP}
\alias{EAP}
\docType{data}
\title{Data collection of igneous rocks from Eastern Mexican Alkaline Province}
\description{
Compilation of major and trace element analysis of 46 igneous rocks from San Carlos-Cruillas, Tamaulipas, Mexico.
}
\usage{data(EAP)}
\format{
The format is a data frame with 46 rows and 28 columns.
}
\details{The origin of the Eastern Mexican Alkaline Province has been explained by landward arc migration and subsequent asthenospheric upwelling after slab roll-back of the Farallon Plate. Detailed geochemical analysis suggests
the participation of two types of metasomatized mantle regions: a lithospheric source modified by past subduction processes and an asthenospheric source slightly affected by carbonatite-related metasomatism. Variations in the partial melting degrees controlled the extent of magma enrichment in the latter. Major and trace element geochemistry, together with geochronological data and field relations, evinced an older post-orogenic setting related to the arc-like rocks (Eocene) and a younger intraplate extensional environment associated with all enriched igneous rocks (Oligocene-Miocene). Bivariate diagrams of SiO2 vs. trace element ratios and multi-element patterns indicate that magmas from the SSCC complex dominantly evolved through fractional crystallization with a limited crustal contribution. 
}

\source{
The database is also available in Elizondo-Pacheco et al. (2022). For full details see \url{https://academic.oup.com/petrology/article/63/5/egac027/6553218} . 
}

\references{
Elizondo-Pacheco, L. A., Ramírez-Fernández, J. A., De Ignacio, C., González-Guzmán, R., Rodríguez-Saavedra, P., Leal-Cuellar, V. A. & Montalvo-Arrieta, J. C. (2022). Generation of Arc-Like and OIB-Like Magmas Triggered by Slab Detachment in the Eastern Mexican Alkaline Province: Petrological Evidence from the Cenozoic Sierra de San Carlos-Cruillas Complex, Tamaulipas. Journal of Petrology, 63(5), egac027.
}
\examples{
data(EAP)
rm(EAP)#cleanup
##
}
\seealso{
\code{\link{Deccan}}
\code{\link{IUGS}}
\code{\link{TephraKam}}
}
\keyword{datasets}


