% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setPulse.R
\name{setPulse}
\alias{setPulse}
\title{Custom pulse animation: UI side}
\usage{
setPulse(id = NULL, class = NULL, duration = 1, iteration = 5)
}
\arguments{
\item{id}{Use this argument if you want to target an individual element.}

\item{class}{The element to which the pulse should be applied.
For example, class is set to box. All elements having the box class
will be affected.}

\item{duration}{Pulse frequency. 1s by default.}

\item{iteration}{Pulse iteration. 5 by default.}
}
\description{
Allow to apply a pulse animation on a given element.
}
\examples{
 if (interactive()) {

  library(shiny)
  library(shinydashboard)
  library(shinydashboardPlus)
  library(shinyEffects)

  boxTag <- boxPlus(
   title = "A box",
   status = "warning",
   solidHeader = FALSE,
   collapsible = TRUE,
   p("Box Content")
  )

  shinyApp(
   ui = dashboardPage(
     header = dashboardHeader(),
     sidebar = dashboardSidebar(),
     body = dashboardBody(

      setPulse(class = "box", duration = 1, iteration = 100),
      setPulse(id = "my-progress", duration = 1, iteration = 100),

      tags$h2("Add pulse animation to the box class"),
      fluidRow(boxTag, boxTag),
      tags$h2("Add pulse animation only to the first element using id"),
      tagAppendAttributes(
       progressBar(
        value = 10,
        striped = TRUE,
        animated = TRUE,
        vertical = TRUE
       ),
       id = "my-progress"
      ),
      progressBar(
       value = 50,
       status = "warning",
       size = "xs",
       vertical = TRUE
      )
     ),
     controlbar = dashboardControlbar(),
     title = "DashboardPage"
   ),
   server = function(input, output) { }
  )
}
}
